/*
 * @(#)ZipMessageBox.java	1.0 98/12/11
 *
 * Java Project performed by
 *     Frank Moisant
 *    Patrick Titiano
 *        (ITRA3)
 *
 */


import com.sun.java.swing.JDialog;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JPanel;

import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.Dimension;
import java.awt.Point;


/**
 * Class to display a simple message with a ok button
 * @version 1.0
 * @author Frank Moisant - Patrick Titiano
 */
public class ZipMessageBox extends JDialog {


    /**
     * Class Constructor
     * @param owner the frame which instanciate the dialog
     * @param title the title of the message box
     * @param message the message to display
     */
    public ZipMessageBox(Frame owner, String title, String message) {
	super(owner,title,true);

	// define le owner location
	Dimension dim = owner.getSize();
	Point loc = owner.getLocation();
	
	// set up the dialog
	JLabel labelMessage = new JLabel(message,JLabel.CENTER);
	JButton okButton = new JButton("OK");
	JPanel panel = new JPanel();
	ButtonListener listener = new ButtonListener(this);

	okButton.setActionCommand("Ok");
	okButton.addActionListener(listener);

	panel.add(okButton);
	panel.setLayout(new FlowLayout(FlowLayout.CENTER));

	getContentPane().add("North",labelMessage);
	getContentPane().add("Center",panel);
	pack();

	// calculate the position of the dialog, in the middle of the owner
	Dimension curdim = getSize();
	setLocation(loc.x + dim.width/2 - curdim.width/2, loc.y + dim.height/2 - curdim.height/2);
	setVisible(true);
    }
    
    /**
     * Class use to listen the ok button
     * @see ZipMessageBox
     * @version 1.0
     * @author Frank Moisant - Patrick Titiano
     */
    private class ButtonListener implements ActionListener {

	// private member
	private ZipMessageBox zipMessageBox;
	

	/**
	 * Class constructor
	 * @param zipMessageBox the message box to listen
	 */
	public ButtonListener(ZipMessageBox zipMessageBox) {
	    super();
	    this.zipMessageBox = zipMessageBox;
	}

	/**
	 * Called when an action performed, here a ok button pressed
	 * @param e the action event
	 */
	public void actionPerformed(ActionEvent e) {
	    String command = e.getActionCommand();
	    if(command.equals("Ok")) {
		zipMessageBox.dispose();
	    }
	}
    }

    /**
     * Return if the dialog is resizable
     * @return always false (the dialog is not resizable)
     */
    public boolean isResizable() {
	return false;
    }
}
